/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CBrush.h,v 1.3 1999/09/20 01:27:07 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CBrush_h	// [
#define Included_CBrush_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CBrush

class CBrush
{
	NOT_COPYABLE(CBrush)

public:
	CBrush();
	CBrush(HBRUSH brush);
	~CBrush();

	CBrush&	operator=(HBRUSH brush);

	operator HBRUSH() const {return mBrush;}
	HBRUSH	Get() const {return mBrush;}

	PGPBoolean	IsAttached() const;
	PGPBoolean	WeCreated() const {return mWeCreated;}

	void	CreateHatch(PGPInt32 style, COLORREF crColor);
	void	CreateSolid(COLORREF crColor);
	void	Attach(HBRUSH brush);
	void	Clear();

private:
	PGPBoolean	mWeCreated;
	HBRUSH		mBrush;
};


// Class CBrush member functions

inline 
CBrush::CBrush() : mWeCreated(FALSE), mBrush(NULL)
{
}

inline 
CBrush::CBrush(HBRUSH brush) : mWeCreated(FALSE), mBrush(NULL)
{
	Attach(brush);
}

inline 
CBrush::~CBrush()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
CBrush& 
CBrush::operator=(HBRUSH brush)
{
	Attach(brush);
	return *this;
}

inline 
PGPBoolean 
CBrush::IsAttached() const
{
	return IsntNull(mBrush);
}

inline 
void 
CBrush::CreateHatch(PGPInt32 style, COLORREF crColor)
{
	Clear();
	mBrush = CreateHatchBrush(style, crColor);

	if (IsNull(mBrush))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

inline 
void 
CBrush::CreateSolid(COLORREF crColor)
{
	Clear();
	mBrush = CreateSolidBrush(crColor);

	if (IsNull(mBrush))
		THROW_ERRORS(kPGPError_GraphicsOpFailed, GetLastError());

	mWeCreated = TRUE;
}

inline 
void 
CBrush::Attach(HBRUSH brush)
{
	if (mBrush == brush)
		return;

	Clear();

	mWeCreated = FALSE;
	mBrush = brush;
}

inline 
void 
CBrush::Clear()
{
	if (WeCreated())
		DeleteObject(mBrush);

	mWeCreated = FALSE;
	mBrush = NULL;
}

_PGP_END

#endif	// ] Included_CBrush_h
